

<?php $__env->startSection('title', 'Error Logs'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-header">
    <h1>Error Logs</h1>
    <p>Monitor and manage application errors</p>
</div>


<div class="dashboard-stats">
    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Total Errors</h3>
            <div class="stat-value"><?php echo e(number_format($stats['total'])); ?></div>
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Unresolved</h3>
            <div class="stat-value" style="color: var(--danger);"><?php echo e(number_format($stats['unresolved'])); ?></div>
            <div class="stat-icon">
                <i class="fas fa-times-circle"></i>
            </div>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Critical</h3>
            <div class="stat-value" style="color: var(--danger);"><?php echo e(number_format($stats['critical'])); ?></div>
            <div class="stat-icon">
                <i class="fas fa-bomb"></i>
            </div>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Today</h3>
            <div class="stat-value"><?php echo e(number_format($stats['today'])); ?></div>
            <div class="stat-icon">
                <i class="fas fa-calendar-day"></i>
            </div>
        </div>
    </div>
</div>


<div class="dashboard-card mb-4">
    <div class="dashboard-card-header">
        <h3>Filters</h3>
    </div>
    <div class="dashboard-card-body">
        <form method="GET" action="<?php echo e(route('admin.errors.index')); ?>" class="form-inline">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Search</label>
                        <input type="text" name="search" class="form-control" placeholder="Search errors..." value="<?php echo e(request('search')); ?>">
                    </div>
                </div>
                
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Level</label>
                        <select name="level" class="form-control">
                            <option value="">All Levels</option>
                            <option value="critical" <?php echo e(request('level') === 'critical' ? 'selected' : ''); ?>>Critical</option>
                            <option value="error" <?php echo e(request('level') === 'error' ? 'selected' : ''); ?>>Error</option>
                            <option value="warning" <?php echo e(request('level') === 'warning' ? 'selected' : ''); ?>>Warning</option>
                        </select>
                    </div>
                </div>
                
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" class="form-control">
                            <option value="">All</option>
                            <option value="unresolved" <?php echo e(request('status') === 'unresolved' ? 'selected' : ''); ?>>Unresolved</option>
                            <option value="resolved" <?php echo e(request('status') === 'resolved' ? 'selected' : ''); ?>>Resolved</option>
                        </select>
                    </div>
                </div>
                
                <div class="col-md-2">
                    <div class="form-group">
                        <label>From</label>
                        <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                    </div>
                </div>
                
                <div class="col-md-2">
                    <div class="form-group">
                        <label>To</label>
                        <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                    </div>
                </div>
                
                <div class="col-md-1 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="dashboard-card mb-4">
    <div class="dashboard-card-body">
        <div class="d-flex justify-content-between align-items-center">
            <div class="bulk-actions" style="display: none;">
                <span class="selected-count">0 errors selected</span>
                <div class="btn-group ml-3">
                    <button type="button" class="btn btn-sm btn-success bulk-resolve">
                        <i class="fas fa-check"></i> Resolve
                    </button>
                    <button type="button" class="btn btn-sm btn-primary bulk-send">
                        <i class="fas fa-paper-plane"></i> Send to Support
                    </button>
                    <button type="button" class="btn btn-sm btn-info bulk-download">
                        <i class="fas fa-download"></i> Download
                    </button>
                    <button type="button" class="btn btn-sm btn-danger bulk-delete">
                        <i class="fas fa-trash"></i> Delete
                    </button>
                </div>
            </div>
            
            <div class="main-actions">
                <button type="button" class="btn btn-sm btn-warning" onclick="clearResolved()">
                    <i class="fas fa-broom"></i> Clear Resolved
                </button>
                <button type="button" class="btn btn-sm btn-secondary" onclick="clearOld()">
                    <i class="fas fa-clock"></i> Clear Old (30+ days)
                </button>
                <a href="<?php echo e(route('admin.errors.index')); ?>" class="btn btn-sm btn-outline-primary">
                    <i class="fas fa-redo"></i> Refresh
                </a>
            </div>
        </div>
    </div>
</div>


<div class="dashboard-card">
    <div class="dashboard-card-body p-0">
        <?php if($errors->count() > 0): ?>
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th width="30">
                            <input type="checkbox" id="select-all">
                        </th>
                        <th>Level</th>
                        <th>Type</th>
                        <th>Message</th>
                        <th>File</th>
                        <th>User</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th width="200">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <input type="checkbox" class="error-select" value="<?php echo e($error->id); ?>">
                        </td>
                        <td>
                            <span class="status-badge status-<?php echo e($error->level_color); ?>">
                                <?php echo e(strtoupper($error->level)); ?>

                            </span>
                        </td>
                        <td>
                            <code style="font-size: 0.8rem;"><?php echo e(class_basename($error->type)); ?></code>
                        </td>
                        <td>
                            <div style="max-width: 300px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;" title="<?php echo e($error->message); ?>">
                                <?php echo e($error->short_message); ?>

                            </div>
                        </td>
                        <td>
                            <small><?php echo e($error->file_location); ?></small>
                        </td>
                        <td>
                            <?php if($error->user): ?>
                                <a href="<?php echo e(route('admin.users.show', $error->user)); ?>"><?php echo e($error->user->name); ?></a>
                            <?php else: ?>
                                <span class="text-muted">Guest</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small><?php echo e($error->created_at->format('M d, Y H:i')); ?></small>
                        </td>
                        <td>
                            <?php if($error->is_resolved): ?>
                                <span class="status-badge status-completed">Resolved</span>
                            <?php else: ?>
                                <span class="status-badge status-pending">Unresolved</span>
                            <?php endif; ?>
                            <?php if($error->is_sent): ?>
                                <i class="fas fa-paper-plane text-info ml-1" title="Sent to support"></i>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="user-actions">
                                <a href="<?php echo e(route('admin.errors.show', $error)); ?>" class="btn-icon btn-info" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                <?php if(!$error->is_resolved): ?>
                                <button type="button" class="btn-icon btn-success resolve-error" data-id="<?php echo e($error->id); ?>" title="Mark as Resolved">
                                    <i class="fas fa-check"></i>
                                </button>
                                <?php endif; ?>
                                
                                <button type="button" class="btn-icon btn-primary send-error" data-id="<?php echo e($error->id); ?>" title="Send to Support">
                                    <i class="fas fa-paper-plane"></i>
                                </button>
                                
                                <a href="<?php echo e(route('admin.errors.download', $error)); ?>" class="btn-icon btn-warning" title="Download">
                                    <i class="fas fa-download"></i>
                                </a>
                                
                                <button type="button" class="btn-icon btn-danger delete-error" data-id="<?php echo e($error->id); ?>" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div class="p-3">
            <?php echo e($errors->links()); ?>

        </div>
        <?php else: ?>
        <div class="empty-state">
            <i class="fas fa-check-circle"></i>
            <h4>No Errors Found</h4>
            <p>Great! Your application is running smoothly with no errors logged.</p>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const selectAll = document.getElementById('select-all');
    const errorSelects = document.querySelectorAll('.error-select');
    const bulkActions = document.querySelector('.bulk-actions');
    const mainActions = document.querySelector('.main-actions');
    const selectedCount = document.querySelector('.selected-count');

    // Select all checkbox
    if (selectAll) {
        selectAll.addEventListener('change', function() {
            errorSelects.forEach(cb => cb.checked = this.checked);
            updateBulkActions();
        });
    }

    // Individual checkboxes
    errorSelects.forEach(cb => {
        cb.addEventListener('change', updateBulkActions);
    });

    function updateBulkActions() {
        const selected = Array.from(errorSelects).filter(cb => cb.checked);
        if (selected.length > 0) {
            bulkActions.style.display = 'flex';
            mainActions.style.display = 'none';
            selectedCount.textContent = `${selected.length} error${selected.length > 1 ? 's' : ''} selected`;
        } else {
            bulkActions.style.display = 'none';
            mainActions.style.display = 'flex';
        }
    }

    // Bulk actions
    document.querySelector('.bulk-resolve')?.addEventListener('click', () => bulkAction('resolve'));
    document.querySelector('.bulk-send')?.addEventListener('click', () => bulkAction('send'));
    document.querySelector('.bulk-download')?.addEventListener('click', () => bulkAction('download'));
    document.querySelector('.bulk-delete')?.addEventListener('click', () => {
        if (confirm('Are you sure you want to delete the selected errors?')) {
            bulkAction('delete');
        }
    });

    function bulkAction(action) {
        const selected = Array.from(errorSelects).filter(cb => cb.checked).map(cb => cb.value);
        if (selected.length === 0) return;

        const routes = {
            resolve: '<?php echo e(route("admin.errors.bulk-resolve")); ?>',
            send: '<?php echo e(route("admin.errors.bulk-send")); ?>',
            download: '<?php echo e(route("admin.errors.bulk-download")); ?>',
            delete: '<?php echo e(route("admin.errors.bulk-delete")); ?>'
        };

        if (action === 'download') {
            window.location.href = routes[action] + '?ids=' + selected.join(',');
            return;
        }

        fetch(routes[action], {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ ids: selected })
        })
        .then(r => r.json())
        .then(data => {
            if (data.success) {
                showNotification(data.message, 'success');
                setTimeout(() => location.reload(), 1500);
            } else {
                showNotification(data.message, 'error');
            }
        });
    }

    // Individual actions
    document.querySelectorAll('.resolve-error').forEach(btn => {
        btn.addEventListener('click', function() {
            const id = this.dataset.id;
            fetch(`/admin/errors/${id}/resolve`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showNotification(data.message, 'success');
                    setTimeout(() => location.reload(), 1000);
                }
            });
        });
    });

    document.querySelectorAll('.send-error').forEach(btn => {
        btn.addEventListener('click', function() {
            const id = this.dataset.id;
            const originalHtml = this.innerHTML;
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
            this.disabled = true;

            fetch(`/admin/errors/${id}/send`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            })
            .then(r => r.json())
            .then(data => {
                showNotification(data.message, data.success ? 'success' : 'error');
                if (data.success) {
                    setTimeout(() => location.reload(), 1500);
                }
            })
            .finally(() => {
                this.innerHTML = originalHtml;
                this.disabled = false;
            });
        });
    });

    document.querySelectorAll('.delete-error').forEach(btn => {
        btn.addEventListener('click', function() {
            if (!confirm('Are you sure you want to delete this error log?')) return;
            
            const id = this.dataset.id;
            fetch(`/admin/errors/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showNotification(data.message, 'success');
                    setTimeout(() => location.reload(), 1000);
                }
            });
        });
    });

    function showNotification(message, type) {
        if (window.adminPanel && window.adminPanel.showNotification) {
            window.adminPanel.showNotification(message, type);
        } else {
            alert(message);
        }
    }
});

function clearResolved() {
    if (!confirm('Are you sure you want to clear all resolved errors?')) return;

    fetch('<?php echo e(route("admin.errors.clear-resolved")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(r => r.json())
    .then(data => {
        alert(data.message);
        location.reload();
    });
}

function clearOld() {
    if (!confirm('Are you sure you want to clear all errors older than 30 days?')) return;

    fetch('<?php echo e(route("admin.errors.clear-old")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(r => r.json())
    .then(data => {
        alert(data.message);
        location.reload();
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/errors/index.blade.php ENDPATH**/ ?>